<?php
session_start();
define('AHK_NO_LINKS', true);
// Start output buffer to prevent stray output breaking JSON
if (!ob_get_level()) { ob_start(); }
include('../includes/config.php');
$OrderId = isset($_POST['order_id']) ? trim($_POST['order_id']) : '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $isAjax = (isset($_POST['ajax']) && $_POST['ajax'] == '1')
        || (isset($_GET['ajax']) && $_GET['ajax'] == '1')
        || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest');
    if (empty($upi_merchant_code) || empty($upi_secret)) { 
        if ($isAjax) {
            // Ensure clean JSON only
            if (ob_get_length()) { ob_clean(); }
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode([
                'status' => 0,
                'message' => 'Gateway not configured. Please set Merchant Code and Secret in settings.'
            ]);
            exit;
        }
        ?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Gateway Not Configured</title>
    <style>
        body{font-family:Arial, sans-serif;background:#f8f9fa;display:flex;align-items:center;justify-content:center;height:100vh;margin:0;}
        .card{background:#fff;border:1px solid #e5e7eb;border-radius:10px;box-shadow:0 10px 20px rgba(0,0,0,0.08);padding:24px;max-width:420px;text-align:center}
        .btn{display:inline-block;margin-top:12px;padding:10px 16px;background:#0d6efd;color:#fff;text-decoration:none;border-radius:6px}
        .warn{color:#dc3545;margin-top:8px}
    </style>
</head>
<body>
    <div class="card">
        <h3>Gateway Not Configured</h3>
        <p>Please enter key</p>
        <p class="warn">Merchant Code (MID) and Secret/Token are required.</p>
        <a class="btn" href="https://<?php echo $_SERVER['SERVER_NAME']; ?>/admin/settings">Open Settings</a>
    </div>
</body>
</html>
<?php exit; }
    $api_token = $upi_secret;

    $customer_mobile = isset($_POST["phone"]) ? preg_replace('/\D+/', '', $_POST["phone"]) : '';
    $amount = isset($_POST["amount"]) ? (string)$_POST["amount"] : '';
    if ($customer_mobile === '' || $amount === '' || $OrderId === '') {
        if ($isAjax) {
            if (ob_get_length()) { ob_clean(); }
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode([
                'status' => 0,
                'message' => 'Missing required fields. phone, amount and order_id are required.'
            ]);
            exit;
        } else {
            header('Content-Type: text/plain; charset=utf-8');
            echo "Missing required fields. phone, amount and order_id are required.";
            exit;
        }
    }
    $data = array(
        "customer_mobile" => $customer_mobile,
        "user_token" => $api_token,
        "amount" => $amount,
        "order_id" => $OrderId,
        "redirect_url" => ((isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . "/pay/secureresponse.php",
    );
    $_SESSION['order_id'] = $OrderId;
    $_SESSION['customer_mobile'] = $customer_mobile;

    $ch = curl_init();
    $curlConfig = array(
        CURLOPT_URL            => "https://payhere.run.place/api/create-order",
        CURLOPT_POST           => true,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POSTFIELDS     => $data,
        CURLOPT_TIMEOUT        => 20,
    );
    curl_setopt_array($ch, $curlConfig);
    $response = curl_exec($ch);
    $curl_err = curl_error($ch);
    curl_close($ch);

    if ($response === FALSE) {
        if ($isAjax) {
            if (ob_get_length()) { ob_clean(); }
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode([
                'status' => 0,
                'message' => 'Network error while contacting payment API',
                'error' => $curl_err
            ]);
            exit;
        } else {
            header('Content-Type: text/plain; charset=utf-8');
            echo 'Error occurred while making the API request: ' . $curl_err;
            exit;
        }
    }

    $result = json_decode($response, true);
    if (is_array($result) && !empty($result['status']) && isset($result['result']['payment_url'])) {
        if ($isAjax) {
            if (ob_get_length()) { ob_clean(); }
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode([
                'status' => 1,
                'payment_url' => $result['result']['payment_url']
            ]);
            exit;
        } else {
            header("Location: " . $result['result']['payment_url']);
            exit();
        }
    }
    if ($isAjax) {
        if (ob_get_length()) { ob_clean(); }
        header('Content-Type: application/json; charset=utf-8');
        echo json_encode([
            'status' => 0,
            'message' => is_array($result) ? ($result['message'] ?? 'Unknown error') : 'Invalid JSON response',
            'raw' => is_array($result) ? null : $response
        ]);
        exit;
    } else {
        header('Content-Type: text/plain; charset=utf-8');
        echo "Payment init failed.\n";
        if (!is_array($result)) {
            echo "Invalid JSON response:\n" . $response;
        } else {
            echo "API message: " . (isset($result['message']) ? $result['message'] : 'Unknown error');
        }
    }
}
?>

<html>
<head>
    <title>Gateway Check Out Page</title>
</head>
<body>
    <center><h1>Please do not refresh this page...</h1></center>
</body>
</html>
